#!/usr/bin/python

# a test for demonstration using Sketch Engine through json interface

import urllib, urllib2, base64
import simplejson

usr = '<username>'
passwd = '<password>'

base_url = 'http://localhost/auth/run.cgi/'
method = 'wordlist'

# creating query string
attrs = dict(corpname='bnc2', wlattr='word', wlpat='test.*',
               format='json')
encoded_attrs = urllib.quote(simplejson.JSONEncoder().encode(attrs))
url = base_url + method + '?json=%s' % encoded_attrs

request = urllib2.Request(url)

# authentication
base64string = base64.encodestring('%s:%s' % (usr, passwd))[:-1]
request.add_header("Authorization", "Basic %s" % base64string)

# json data receiving
file = urllib2.urlopen(request)
data = file.read()
file.close()

# now, in the 'data' variable, there is a json string that can be parsed
# for json syntax (e.g. by simplejson)
json_obj = simplejson.loads(data)
print simplejson.dumps(json_obj, sort_keys=True, indent=3)

