#!/usr/bin/env python

# a test for demonstration using Sketch Engine through json interface

import urllib, urllib2, base64, json

usr = '<username>'
passwd = '<password>'

base_url = 'http://localhost/auth/run.cgi/'
method = 'view'

# creating query string
attrs = dict(corpname='bnc2', q='', pagesize='1', format='json')
# query_list can be read from a file, ...
query_list = ['[lemma="test"]',
              '[lemma="drug"][lemma="test"]',
              '[lemma="blood"][lemma="test"]',
              '[lemma="test"][lemma="result"]'
             ]

for query in query_list:
    attrs['q'] = 'q' + query

    encoded_attrs = urllib.quote(json.dumps(attrs))
    url = base_url + method + '?json=%s' % encoded_attrs

    request = urllib2.Request(url)

    # authentication
    base64string = base64.encodestring('%s:%s' % (usr, passwd))[:-1]
    request.add_header("Authorization", "Basic %s" % base64string)

    # json data receiving
    file = urllib2.urlopen(request)
    data = file.read()
    file.close()

    # now, in the 'data' variable, there is a json string that can be parsed
    # for json syntax
    json_obj = json.loads(data)

    print query + '\t' + str(json_obj.get('concsize', '0'))


