import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.cookie.CookiePolicy;
import org.apache.commons.httpclient.methods.*;
import org.apache.commons.httpclient.protocol.*;
import org.apache.commons.httpclient.contrib.ssl.*;
import org.json.*;
import java.util.*;
import java.io.*;

/**
 * @author Vojtech Kovar, xkovar3(at)fi.muni.cz
 * @author Milos Jakubicek, xjakub(at)fi.muni.cz
 * @author Nosmo King, hatejava@mailinator.com
 */

class example3_ca {

    static final String root_url = "beta.sketchengine.co.uk";
    static final String ske_username = "<username>";
    static final String ske_password = "<password>";
   
    public static void main(String[] args) {
        
        String corp = "bnc2";
        String method = "view";
        String base_url = "/bonito/run.cgi/";
        // specifying attributes
        Map attrs = new HashMap();
        attrs.put("corpname", corp);
        attrs.put("pagesize", "1");
        attrs.put("format", "json");
       
        // query list can be loaded from a file, ...
        int qlist_size = 4;
        String query_list[] = new String[qlist_size];
        query_list[0] = "[lemma=\"test\"]";
        query_list[1] = "[lemma=\"drug\"][lemma=\"test\"]";
        query_list[2] = "[lemma=\"blood\"][lemma=\"test\"]";
        query_list[3] = "[lemma=\"test\"][lemma=\"result\"]";

        // make HTTPS connection
        String cookie_policy = CookiePolicy.DEFAULT; //use CookiePolicy.BROWSER_COMPATIBILITY in case cookie handling does not work
        HttpClient client = new HttpClient();
        try {
          Protocol.registerProtocol("https", new Protocol("https", (ProtocolSocketFactory) new EasySSLProtocolSocketFactory(), 443));
          //client.getHostConfiguration().setHost(root_url, 80, "http");
          client.getHostConfiguration().setHost(root_url, 443, "https");
          client.getParams().setCookiePolicy(cookie_policy);
        } catch (java.security.GeneralSecurityException e){
          e.printStackTrace();
        } catch (IOException e){
          e.printStackTrace();
        }
        client.getParams().setCookiePolicy(cookie_policy);
        
        // retrieve session id
        GetMethod authget = new GetMethod("/login/");
        try {
            int code=client.executeMethod(authget);
        } catch (IOException ex) {
            System.err.println("Error: couldn't retrieve session ID from Sketch Engine server.");
            System.exit(1);
        }
        authget.releaseConnection();
        
        // login    
        PostMethod authpost = new PostMethod("/login/");
        NameValuePair submit   = new NameValuePair("submit", "ok");
        NameValuePair username = new NameValuePair("username", ske_username);
        NameValuePair password = new NameValuePair("password", ske_password);
        authpost.setRequestBody(new NameValuePair[] {submit, username, password});
           try {
             int code=client.executeMethod(authpost);
        } catch (IOException ex) {
            System.err.println("Error: couldn't login to Sketch Engine server.");
            System.exit(2);
        }
        authpost.releaseConnection();

        // retrieve data
        for (int i = 0; i < qlist_size; i++) {
            try {
                attrs.put("q", "q" + query_list[i]);
                JSONObject json_query = new JSONObject(attrs);
                String url_string = base_url + method + "?json=" + json_query.toString();
                GetMethod getJSON = new GetMethod(new URI(url_string, false).toString());
                client.executeMethod(getJSON);
                JSONObject json = new JSONObject(new BufferedReader(new InputStreamReader (getJSON.getResponseBodyAsStream())).readLine());
                System.out.println(query_list[i] + "\t" + json.get("concsize").toString());
                getJSON.releaseConnection();
            } catch (URIException ex) {
                System.err.println("Error: malformed URI in request.");
            } catch (JSONException ex) {
                System.err.println("Error: malformed JSON format.");
            } catch (IOException ex) {
                System.err.println("Error: couldn't retrieve JSON data from Sketch Engine server.");
            }
        }
    }
}
