#!/bin/bash

usage() 
{
cat << EOF

Usage: $(basename $0) (-h) (-f <MULTISEP>) corpname struct src_attr new_attrname map_file [tmpdir]

OPTIONS:

-m <MULTISEP>    if a <MULTISEP> character is supplied the new attribute will be handled as MULTVALUE=yes  

-h               Print this message
EOF
}

export optm=""
 
## parse input parameters 
while getopts "hm:" OPTION; do
        case $OPTION in
                m)
                        optm=$OPTARG
                        ;;
                h) 
                        usage
                        exit 1
                        ;;
        esac
done
shift "$((OPTIND-1))"


if [ $# -gt 6 -o $# -lt 5 ]; then
        usage
        exit 1
fi

if [ $# = 5 ]; then
        export tmpdir=/tmp
else
        export tmpdir=$6
fi

if [ ! $MANATEE_REGISTRY ]; then
        echo warning: MANATEE_REGISTRY not set - setting to /corpora/registry
        export MANATEE_REGISTRY=/corpora/registry
fi

export corpname=$1
export struct=$2
export newattr=$4
export corp_data_path=`corpinfo -p $corpname`
# export param5=`pwd`/$5
export param5=$5

if [ ! $corp_data_path ]; then
        echo Error: corpus data not found
        exit 2
fi

echo creating working directories in $tmpdir ...
rm -rf $tmpdir/$corpname
mkdir -p $tmpdir/$corpname/data

echo -e "\n cd to `dirname $0` ... \n"
cd `dirname $0`

#echo creating vertical file $tmpdir/$corpname/add.vert ...
./create_vertical.py $1 $2 $3 $4 $param5 > $tmpdir/$corpname/add.vert

echo creating a dummy registry file for just the new attribute $tmpdir/$corpname/add.registry ...
./create_registry.py -m "$optm" $corpname $struct $newattr $tmpdir | tee  $tmpdir/$corpname/add.registry

#echo running encodevert ...
## encodevert -v -p $tmpdir/$corpname/data -a x -s $struct -x $tmpdir/$corpname/add.vert
encodevert -c $tmpdir/$corpname/add.registry

echo Now manually copy files to $corp_data_path ...
echo -e "\nCall:\n\n\t cp -v $tmpdir/$corpname/data/$struct.$newattr* $corp_data_path \n"

echo finished

